﻿// Copyright 2023 Open Text.
// The only warranties for products and services of Open Text and its affiliates and licensors (“Open Text”) are as may be set forth in the express warranty statements accompanying such products and services. Nothing herein should be construed as constituting an additional warranty. Open Text shall not be liable for technical or editorial errors or omissions contained herein. The information contained herein is subject to change without notice.

(function () {

function addAnchors()
{
    const headings = document.querySelectorAll('div.main h2');
    
    for (let h = 0; h < headings.length; h++)
    {
        let anchorName = headings[h].id;
        
        if (!anchorName)
        {
            // HTML5 specification states that IDs must be unique within a
            // document, and must not contain whitespace
            let checkUnique = headings[h].textContent.replace(/[^a-zA-Z0-9]/g, '-').substring(0,16);
            
            anchorName = checkUnique;
            let counter = 0;
            while (document.getElementById(anchorName))
            {
                anchorName = checkUnique.concat(++counter);
            }
            
            headings[h].id = anchorName;
        }
        
        const directLink = document.createElement("a");
        directLink.textContent = "(link)";
        directLink.classList.add("directLink");
        directLink.setAttribute("href", location.pathname + "#" + encodeURIComponent(anchorName));
        headings[h].appendChild(directLink);
    }
}


if (document.readyState === 'loading')
{
    document.addEventListener('DOMContentLoaded', addAnchors);
}
else
{
    addAnchors();
}

})();